﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Sales.Quotations
{
    public partial class Quotations : System.Web.UI.Page
    {
        private Entities.Quotations currentQuotation;
        private static int mode;

        protected void Page_Load(object sender, EventArgs e)
        {
          WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                mode = 0;
                if (Request.QueryString["mode"] != null)
                {
                    try
                    {
                        mode = int.Parse(Request.QueryString["mode"].ToString());
                    }
                    catch { }
                }

                BindQuotationsList(string.Empty, DateTime.MinValue, DateTime.MinValue, mode);
            }
        }

        protected void btnExportToExcel(object sender, EventArgs e)
        {
            BindQuotationsList(string.Empty,DateTime.MinValue, DateTime.MinValue,0);
            Master.ExportToExcel<Entities.Quotations>(grdQuotations, "Quotations");
        }

        private void BindQuotationsList(string searchWord, DateTime fromDate, DateTime toDate, int mode)
        {
            List<Entities.Quotations> pcList = QuotationsBL.GetList(Guid.Empty, searchWord, fromDate, toDate);
            pcList = (from pl in pcList
                      orderby pl.QuotationsNumber descending
                      select pl).ToList<Entities.Quotations>();

            switch (mode)
            {
                case 1:
                    pcList = (from pl in pcList
                              where pl.QuotationsStatus.ToLower() == "new"
                              select pl).ToList<Entities.Quotations>();
                    break;
                case 2:
                    pcList = (from pl in pcList
                              where pl.QuotationsStatus.ToLower() == "pending"
                              select pl).ToList<Entities.Quotations>();
                    break;
                case 3:
                    pcList = (from pl in pcList
                              where pl.QuotationsStatus.ToLower() == "processed"
                              select pl).ToList<Entities.Quotations>();
                    break;
                case 4:
                    pcList = (from pl in pcList
                              where pl.QuotationsStatus.ToLower() == "canceled"
                              select pl).ToList<Entities.Quotations>();
                    break;
            }

            if (chkShowPOS.Checked)
            {
                pcList = (from pl in pcList
                          where pl.OrderFrom.Trim().ToLower().Equals("pos")
                          select pl).ToList<Entities.Quotations>();
            }
            else if (chkShowWeb.Checked)
            {
                pcList = (from pl in pcList
                          where pl.OrderFrom.Trim().ToLower().Equals("web")
                          select pl).ToList<Entities.Quotations>();
            }

            grdQuotations.DataSource = pcList;
            grdQuotations.DataBind();

            if (pcList.Count == 0)
                WebUtilities.ShowMessage(this, "No Quotations found");
        }

        protected void grdQuotations_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            grdQuotations.PageIndex = e.NewPageIndex;
            BindQuotationsList(txtSearch.Text.Trim(), (string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                         (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)), mode);
        }

        protected void grdQuotations_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                //Label lblCategoryName = e.Row.FindControl("lblCategoryName") as Label;
                //Label lblSubCategoryName = e.Row.FindControl("lblSubCategoryName") as Label;
                //Label lblBrandName = e.Row.FindControl("lblBrandName") as Label;
                //Label lblColorName = e.Row.FindControl("lblColorName") as Label;

                //Entities.Products curProd = (Entities.Products)e.Row.DataItem;

                //lblCategoryName.Text = ProductCategoryBL.GetItem(curProd.ProductCategoryID, string.Empty).CategoryName;
                //lblSubCategoryName.Text = ((curProd.ProductSubCategoryID != null && curProd.ProductSubCategoryID != Guid.Empty) ? ProductSubCategoryBL.GetItem(curProd.ProductSubCategoryID, Guid.Empty, string.Empty).SubCategoryName : string.Empty);
                //lblBrandName.Text = ((curProd.ProductBrandID != null && curProd.ProductBrandID != Guid.Empty) ? ProductBrandBL.GetItem(curProd.ProductBrandID, string.Empty).BrandName : string.Empty);
                //lblColorName.Text = ((curProd.ProductColorID != null && curProd.ProductColorID != Guid.Empty) ? ProductColorBL.GetItem(curProd.ProductColorID, string.Empty).ColorName : string.Empty);
            }
        }

        protected void lnkEditOrder_Click(object sender, EventArgs e)
        {
            hdQuotationID.Value = string.Empty;
            LinkButton lnkEditOrder = (LinkButton)sender;
            if (lnkEditOrder != null)
            {
                hdQuotationID.Value = lnkEditOrder.CommandArgument.ToString();
                Guid ordersID = new Guid(hdQuotationID.Value);
                currentQuotation = QuotationsBL.GetItem(ordersID, string.Empty, DateTime.MinValue, DateTime.MinValue);

                if (currentQuotation != null)
                {
                    ddlQuotationStatus.SelectedIndex = ddlQuotationStatus.Items.IndexOf(ddlQuotationStatus.Items.FindByValue(currentQuotation.QuotationsStatus));
                    ScriptManager.RegisterStartupScript(this, GetType(), "testscript", "$('#divPaymentStatus').modal();", true);
                }
            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            if (hdQuotationID.Value.Trim().Length != 0)
            {
                string remarks = string.Empty;
                Guid ordersID = new Guid(hdQuotationID.Value);
                currentQuotation = QuotationsBL.GetItem(ordersID, string.Empty, DateTime.MinValue, DateTime.MinValue);

                if (currentQuotation != null)
                {
                    if (currentQuotation.QuotationsStatus.ToLower() != ddlQuotationStatus.SelectedValue.ToLower())
                    {
                        remarks += string.Format("Quotation Status from {0} to {1}.", currentQuotation.QuotationsStatus, ddlQuotationStatus.SelectedValue);
                    }

                    currentQuotation.Mode = GlobalConfigurations.Mode.Update;
                    currentQuotation.QuotationsStatus = ddlQuotationStatus.SelectedValue;
                    currentQuotation.AdminUserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);

                    foreach (QuotationsDetails od in currentQuotation.QuotationsDetailsList)
                    {
                        od.Mode = GlobalConfigurations.Mode.Update;
                        od.QuotationsStatus = ddlQuotationStatus.SelectedValue;
                    }

                    if (QuotationsBL.Save(currentQuotation))
                    {
                        if (remarks.Trim().Length != 0)
                            AuditTrailBL.Save(currentQuotation.UniqueID, WebSession.GetUserIP(), remarks, Guid.Empty, currentQuotation.AdminUserAccountID);

                        WebUtilities.ShowMessage(this, "Quotations details has been modified successfully");
                        BindQuotationsList(txtSearch.Text.Trim(), (string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                         (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)), 0);
                    }
                }
            }
        }

        protected void btnCancel_Click(object sender, EventArgs e)
        {
            hdQuotationID.Value = string.Empty;
        }

        protected void lnkSendToPayment_Click(object sender, EventArgs e)
        {
            hdQuotationID.Value = string.Empty;
            LinkButton lnkEditOrder = (LinkButton)sender;
            if (lnkEditOrder != null)
            {
                hdQuotationID.Value = lnkEditOrder.CommandArgument.ToString();
                Guid ordersID = new Guid(hdQuotationID.Value);
                currentQuotation = QuotationsBL.GetItem(ordersID, string.Empty, DateTime.MinValue, DateTime.MinValue);

                if (currentQuotation != null)
                {
                    int modifiedItems = (from qd in currentQuotation.QuotationsDetailsList
                                         where qd.UnitPrice > qd.OrderPrice
                                         select qd).Count();

                    if (modifiedItems > 0)
                    {
                        currentQuotation.Mode = GlobalConfigurations.Mode.Update;
                        currentQuotation.QuotationsStatus = "Pending";
                        currentQuotation.ExpiryDate = DateTime.Now.AddDays(30);
                        currentQuotation.AdminUserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);
                        if (QuotationsBL.Save(currentQuotation))
                        {
                            AuditTrailBL.Save(currentQuotation.UniqueID, WebSession.GetUserIP(), "Quotations details emailed for payment.", Guid.Empty, currentQuotation.AdminUserAccountID);

                            WebSession.SendQuotationToPaymentEmail(currentQuotation);
                            WebUtilities.ShowMessage(this, "Quotations details has been emailed for payment.");
                            BindQuotationsList(txtSearch.Text.Trim(), (string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                             (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)), 0);
                        }
                    }
                    else
                    {
                        WebUtilities.ShowMessage(this, "Item price has not been revised. Please make changes in item price and try again.");
                    }
                }
            }
        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            if (txtFromDate.Text.Trim().Length != 0 && !ValidationUtility.ValidateDate(txtFromDate.Text.Trim(), "dd/MM/yyyy"))
            {
                WebUtilities.ShowMessage(this, "Please select valid From Date");
                return;
            }

            if (txtToDate.Text.Trim().Length != 0 && !ValidationUtility.ValidateDate(txtToDate.Text.Trim(), "dd/MM/yyyy"))
            {
                WebUtilities.ShowMessage(this, "Please select valid To Date");
                return;
            }

            BindQuotationsList(txtSearch.Text.Trim(), (string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                         (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)), 0);
        }

        protected void btnShowAll_Click(object sender, EventArgs e)
        {
            BindQuotationsList(string.Empty, DateTime.MinValue, DateTime.MinValue, 0);
        }

        protected void lnkDesignerInfo_Click(object sender, EventArgs e)
        {
            hdQuotationID.Value = string.Empty;
            LinkButton lnkDesignerInfo = (LinkButton)sender;
            if (lnkDesignerInfo != null)
            {
                hdQuotationID.Value = lnkDesignerInfo.CommandArgument.ToString();
                Guid quoteID = new Guid(hdQuotationID.Value);
                currentQuotation = QuotationsBL.GetItem(quoteID, string.Empty, DateTime.MinValue, DateTime.MinValue);

                if (currentQuotation != null)
                {
                    txtDesignerName.Text = currentQuotation.DesignerName;
                    txtDesignerRemarks.Text = currentQuotation.DesignerRemarks;

                    ScriptManager.RegisterStartupScript(this, GetType(), "testscript", "$('#divDesignerInfo').modal();", true);
                }
            }
        }

        protected void btnSaveDesigner_Click(object sender, EventArgs e)
        {
            if (hdQuotationID.Value.Trim().Length != 0)
            {
                Guid quoteID = new Guid(hdQuotationID.Value);
                currentQuotation = QuotationsBL.GetItem(quoteID, string.Empty, DateTime.MinValue, DateTime.MinValue);

                if (currentQuotation != null)
                {
                    currentQuotation.Mode = GlobalConfigurations.Mode.Update;
                    currentQuotation.DesignerName = txtDesignerName.Text.Trim();
                    currentQuotation.DesignerRemarks = txtDesignerRemarks.Text.Trim();
                    currentQuotation.AdminUserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);

                    foreach (QuotationsDetails od in currentQuotation.QuotationsDetailsList)
                    {
                        od.Mode = GlobalConfigurations.Mode.Update;
                    }

                    if (QuotationsBL.Save(currentQuotation))
                    {
                        WebUtilities.ShowMessage(this, "Designer Info has been modified successfully");
                        BindQuotationsList(txtSearch.Text.Trim(), (string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                                     (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)), 0);
                    }
                }
            }
        }

        protected void btnCancelDesigner_Click(object sender, EventArgs e)
        {
            hdQuotationID.Value = string.Empty;
        }

        protected void lnkHistroy_Click(object sender, EventArgs e)
        {
            hdQuotationID.Value = string.Empty;
            LinkButton lnkHistroy = (LinkButton)sender;
            if (lnkHistroy != null)
            {
                hdQuotationID.Value = lnkHistroy.CommandArgument.ToString();
                Guid referenceID = new Guid(hdQuotationID.Value);

                grdHistory.DataSource = AuditTrailBL.GetList(Guid.Empty, referenceID);
                grdHistory.DataBind();

                ScriptManager.RegisterStartupScript(this, GetType(), "testscript", "$('#divHistory').modal();", true);
            }
        }

        protected void grdHistory_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                Label lblName = e.Row.FindControl("lblName") as Label;
                Label lblRemarks = e.Row.FindControl("lblRemarks") as Label;

                AuditTrail aud = (AuditTrail)e.Row.DataItem;
                UserAccount adminAcc = UserAccountBL.GetItem(aud.AdminUserAccountID, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);

                lblName.Text = string.Format("{0} {1}", adminAcc.FirstName, adminAcc.LastName);
                lblRemarks.Text = aud.Remarks.Replace(Environment.NewLine, "<br>");
            }
        }
    }
}